#!/bin/bash
export datasets1="Cora CiteSeer PubMed cs wikics"
export datasets2="physics OGBN-Arxiv"
export missing_rates="0.0 0.9 0.999 0.9999"
export train_ratios="0.01"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 0.0001 0.001 0.01 0.1 1 10"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=0

# for missing_rate in $missing_rates
# do
# for train_ratio in $train_ratios
# do
# python main.py --dataset Cora --missing_type uniform --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder LP --lp_alpha 0.99 --n_runs 3 --gpu ${gpu}
# python main.py --dataset Cora --missing_type uniform --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder GNN --gnn GCN --filling_method fp --n_runs 3 --gpu ${gpu}
# python main.py --dataset Cora --missing_type uniform --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder Correct_Smooth --n_runs 3 --gpu ${gpu}
# python main.py --dataset Cora --missing_type uniform --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder GNN --gnn GCN --filling_method zero --label_trick True --mask_rate 1.0 --use_coef True --n_runs 3 --gpu ${gpu}
# python main.py --dataset Cora --missing_type uniform --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder GOODIE --gnn GCN --lp_alpha 0.99 --lamb 1.0 --n_runs 3 --gpu ${gpu}
# done
# done

# for missing_rate in $missing_rates
# do
# for train_ratio in $train_ratios
# do
# python main.py --dataset CiteSeer --missing_type uniform --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder LP --lp_alpha 0.999 --n_runs 3 --gpu ${gpu}
# python main.py --dataset CiteSeer --missing_type uniform --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder GNN --gnn GCN --filling_method fp --n_runs 3 --gpu ${gpu}
# python main.py --dataset CiteSeer --missing_type uniform --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder Correct_Smooth --n_runs 3 --gpu ${gpu}
# python main.py --dataset CiteSeer --missing_type uniform --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder GNN --gnn GCN --filling_method zero --label_trick True --mask_rate 1.0 --use_coef True --n_runs 3 --gpu ${gpu}
# python main.py --dataset CiteSeer --missing_type uniform --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder GOODIE --gnn GCN --lp_alpha 0.999 --lamb 1.0 --n_runs 3 --gpu ${gpu}
# done
# done

for missing_rate in $missing_rates
do
for train_ratio in $train_ratios
do
python main.py --dataset PubMed --missing_type structural --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder LP --lp_alpha 0.999 --n_runs 3 --gpu ${gpu}
python main.py --dataset PubMed --missing_type structural --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder GNN --gnn GCN --filling_method fp --n_runs 3 --gpu ${gpu}
python main.py --dataset PubMed --missing_type structural --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder Correct_Smooth --n_runs 3 --gpu ${gpu}
python main.py --dataset PubMed --missing_type structural --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder GNN --gnn GCN --filling_method zero --label_trick True --mask_rate 1.0 --use_coef True --n_runs 3 --gpu ${gpu}
python main.py --dataset PubMed --missing_type structural --missing_rate ${missing_rate} --train_ratio ${train_ratio} --embedder GOODIE --gnn GCN --lp_alpha 0.999 --lamb 0.0001 --n_runs 3 --gpu ${gpu}
done
done